        @program prog_code,prog_name
	include macros.h

; Tic Tac Toe
; By Don Barnes <x96barnes3@wmich.edu>
; Copyright 1996
; The MF TI-Calc page: Fargo, ti-92, ti-82
; http://www.geocities.com/SiliconValley/Park/1809/
; 
; This is my first experience of any kind with ASM programming.
; If you see anything that I am doing incorrectly or in an
; inefficient way, please email me.  Thanks, drb
;
; p.s. feel free to tear this program to shreds.
;
; ************** Start of Fargo prog **************
prog_code:
	jsr	flib[clr_scr]	;clear screen
	bsr	clear
	move.w	#120,xpos	;sets coordinates for x and o (center of shape)
	move.w	#75,ypos
	bsr	drawx		; calls draw X subroutine
	move.w	#80,xpos	;sets coordinates for x and o (center of shape)
	move.w	#75,ypos
	bsr	drawo		; calls draw O subroutine
	move.w	#40,xpos	;sets coordinates for x and o (center of shape)
	move.w	#75,ypos
	bsr	drawx		; calls draw X subroutine
	move.w	#160,xpos	;sets coordinates for x and o (center of shape)
	move.w	#75,ypos
	bsr	drawo		; calls draw O subroutine
	move.w	#200,xpos	;sets coordinates for x and o (center of shape)
	move.w	#75,ypos
	bsr	drawx		; calls draw X subroutine
        SetFont  #2		; macro.c stuff
        WriteStr #50,#10,#1,tit1
        SetFont  #1
        WriteStr #10,#30,#1,tit2
        WriteStr #76,#45,#1,tit3
        WriteStr #52,#100,#1,tit5
	jsr	flib[idle_loop]		;pause
	move.w	#0,turn		;turn no.
        SetFont #1

gameloop:
	add.w	#1,turn		;next player
	cmp.w	#3,turn
	beq	nett
	WriteStr        #1,#1,#1,txturn
	move.w  turn,d0
	moveq   #1,d1
	lea     tstr(PC),a0
	bsr ConvStr
	WriteStr #46,#1,#4,tstr
	move.w	#2,xcur
	move.w	#2,ycur
turnloop:
	move.w	#0,keyz
	jsr	flib[clr_scr]		;clear screen
	WriteStr #1,#1,#1,txturn
	WriteStr #46,#1,#4,tstr
	bsr	grid		;draws grid #
	bsr	drawcur
	jsr	flib[idle_loop]	 ;pause
	move.w	d0,keyz
	bsr	checkkey
	cmp.w	#263,keyz
	beq	newgame
	cmp.w	#340,keyz
	beq	right
	cmp.w	#337,keyz
	beq	left
	cmp.w	#338,keyz
	beq	up
	cmp.w	#344,keyz
	beq	down
afterkeys:			;This is where program returns if a key was pushed
	cmp.w	#0,d4		;check d4, which is trigger for enter or esc push
	beq	turnloop	;if no key has been pushed, goto turnloop
	cmp.w	#264,keyz	;check for esc
	beq	ending   	;if esc key has been pressed, end
	move.w	xcur,d5
	move.w	ycur,d6
	bsr	getval
	cmp.w   #0,d0		;check to see if square is empty
	bne	turnloop	;if not, try another one
	move.w	turn,d0		;value for square will = turn no
	bsr	setval		;set table value
	bra	gameloop	;loop
ending:
	rts

nett:	;sets turn to zero, for player 1, not sure how else to accomplish this
	move.w		#0,turn
	bra		gameloop

checkkey:	;trips a flag d4 if ENTER or ESC keys are pushed
	move.w	#0,d4
	cmp.w	#13,keyz
	beq	mi
	cmp.w	#264,keyz
	beq	mi
	rts
mi:
	move.w	#1,d4
	rts

right:
	cmp.w	#3,xcur
	bne	ra
	bra	afterkeys
ra:
	add.w	#1,xcur
	bra	afterkeys
left:
	cmp.w	#1,xcur
	bne	la
	bra	afterkeys
la:
	sub.w	#1,xcur
	bra	afterkeys
up:
	cmp.w	#1,ycur
	bne	ua
	bra	afterkeys
ua:
	sub.w	#1,ycur
	bra	afterkeys
down:
	cmp.w	#3,ycur
	bne	da
	bra	afterkeys
da:
	add.w	#1,ycur
	bra	afterkeys

; **********Draw the Cursor
drawcur:
	move.w	xcur,d1
	move.w	ycur,d0
	sub.w	#1,d1
	sub.w	#1,d0
	muls.w	#30,d1
	muls.w	#30,d0
	add.w	#75,d1
	add.w	#11,d0
	move.w	d0,y
	move.w	#0,x2
lftb:			;draw topbottom left line
	move.w	y,d0
	add.w	#1,d1
	move.w	d0,-(a7)	;throws y and then x on stack
	move.w	d1,-(a7)
	jsr	flib[pixel_chg]	;calls pixel_chg from flib
	lea	4(a7),a7	;returns stack pointer to correct position	
	move.w	y,d0
	add.w	#28,d0
	move.w	d0,-(a7)	;throws y and then x on stack
	move.w	d1,-(a7)
	jsr	flib[pixel_chg]	;calls pixel_chg from flib
	lea	4(a7),a7	;returns stack pointer to correct position
	add.w	#1,x2
	cmp	#28,x2
	bne	lftb
	rts

; ************ My Square Root Finder
; *** input d0
; *** output d1 = the lowest interger value greater than or equal to the actual sqrroot of d0
; *** also needs to use d2 for base

root:
	move.w	#0,d1
lprt:
	add.w	#1,d1	;adds 1 to counter d1
	move.w	d1,d2	;set d1=d2
	muls.w	d1,d2	;multiplies (d2*d1)=?(d1^2) get it?!
	cmp.w	d0,d2	; compare d1^2 to d0 if d1 is the approximate sqroot of d0, d2 will be equl to or greater than d0
	blt	lprt
;if d2(which equals d1^2) is less than 0, loop
	rts		;return

; ********************** Clear board
clear:
	move.w	#0,d0
clloop:
	lea	board,a0
	adda.w	d0,a0	
	move.w	#0,(a0)
	add.w	#2,d0
	cmp.w	#22,d0
	bne	clloop
	rts

; ************ Draw X **************
drawx:
	move.w	#15,x2		;sets counter for length of line
loopxa:
	move.w	xpos,d0		;move xpos to a register
	sub.w	x2,d0		;subtract counter x2 (line starts out and draws inward)
	move.w	ypos,d1		;same for y
	sub.w	x2,d1
	move.w	d1,-(a7)	;throws y and then x on stack
	move.w	d0,-(a7)
	jsr	flib[pixel_on]	;calls pixel_on from flib
	lea	4(a7),a7	;returns stack pointer to correct position

	move.w	xpos,d0		; all the same for the other line that makes up the X...
	add.w	x2,d0
	move.w	ypos,d1
	sub.w	x2,d1
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7

	sub.w	#1,x2	;subtracts 1 from the counter X2
	move.w	#0,d0	;sets d0 to 0
	sub.w	#15,d0	;subts 15 from 0 to get a negative 15
	cmp.w	x2,d0	;compares -15 and x2
	bne	loopxa	; if x2 still isn't down to -15, branch to loopxa
	rts		; return

; ************ Gimme an O... oh *** DRAW O
drawo:
	move.w	#0,x2
	sub.w	#14,x2
loopoa:
	move.w	x2,d1		;puts x2 in register
	muls.w	x2,d1		; ^2
	move.w  #196,d0
	sub.w	d1,d0
	bsr	root
;get sqrroot of d0
	move.w	d1,y
	move.w	xpos,d3		;sets x
	add.w	x2,d3		;adds counter factor
	add.w	ypos,d1		;shifts y to wherever center is
	move.w	d1,-(a7)	;bottom half
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	move.w	ypos,d1
	sub.w	y,d1		;subtract y fram ypos for top
	move.w	d1,-(a7)	;top half
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	move.w	x2,d1		;calc left half
	add.w	ypos,d1
	move.w	y,d3
	add.w	xpos,d3
	move.w	d1,-(a7)	;left half (because some is missed by top and bottom)
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	move.w	x2,d1		;calc right half
	add.w	ypos,d1
	move.w	xpos,d3
	sub.w	y,d3
	move.w	d1,-(a7)	;right half (because some is missed by top and bottom)
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	add.w	#1,x2
	cmp.w	#14,x2
	bne	loopoa
	rts
; ********** Get Table value
getval:
	lea	board,A0
	move.w	d6,d2
	muls.w	#3,d2
	sub.w	#3,d2
	add.w	d5,d2
	muls.w	#2,d2		;d2*2 for 2 bytes
	adda.w	d2,a0	
	move.w	(a0),d0
	rts
; ********** Set Table value
setval:
	lea	board,A0	;load table address
	move.w	d6,d2		;row
	muls.w	#3,d2		;ROW*3
	sub.w	#3,d2		;-3
	add.w	d5,d2		;+ column
	muls.w	#2,d2		;d2*2 for 2 bytes
	adda.w	d2,a0	
	move.w	d0,(a0)
	rts
	

; ********** Draw grid
grid:
	move.w	#75,d3	;set counter
gloop:
	move.w	#40,d1
	move.w	d1,-(a7)	;top line horiz
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	move.w	#70,d1
	move.w	d1,-(a7)	;bottom line horiz
	move.w	d3,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	add.w	#1,d3
	cmp	#165,d3
	bne	gloop
	move.w	#10,d3	;set counter ;set y counter
gloopb:
	move.w	#105,d1
	move.w	d3,-(a7)	;left line vert
	move.w	d1,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	move.w	#135,d1
	move.w	d3,-(a7)	;right line vert
	move.w	d1,-(a7)
	jsr	flib[pixel_on]
	lea	4(a7),a7
	add.w	#1,d3
	cmp	#100,d3
	bne	gloopb
; DRAWS X's and O's on game board
	move.w	#1,cy
loopgy:
	move.w	#1,cx
loopgx:		
;all this junk shifts and skews values to fit x's and o's on grid
	move.w	cx,d4
	muls.w	#30,d4
	add.w	#60,d4
	move.w	d4,xpos
	move.w	cy,d3
	sub.w	#1,d3
	muls.w	#30,d3
	add.w	#25,d3
	move.w	d3,ypos
	move.w	cx,d5
	move.w	cy,d6
	bsr	getval ;get value of who's in this spot on board, x or o
	cmp.w	#1,d0	;if x is here
	beq	gdxxx	;draw x
	cmp.w	#2,d0	;if o is here
	beq	gdooo	draw o
returnhere:
	add.w   #1,cx
	cmp.w	#4,cx
	bne	loopgx
	add.w   #1,cy
	cmp.w	#4,cy
	bne	loopgy
	rts
gdxxx:
	bsr	drawx
	bra returnhere
gdooo:
	bsr	drawo
	bra returnhere
; ********** Converts a number to a string

ConvStr:
 adda.l  d1,a0
 clr.b   (a0)
 subq.b  #1,d1
RepConv:
 divu    #10,d0
 move.l  d0,d2
 lsr.l   #8,d2
 lsr.l   #8,d2
 add.b   #48,d2
 move.b  d2,-(a0)
 and.l   #$FFFF,d0
 dbra    d1,RepConv
 rts

; new *****
newgame:
	bsr	clear
	bra	prog_code
; ******************* "variables" ********************
prog_name:	dc.b	"Tic Tac Toe v1.0",129,0	;name which will appear on Fargo menu
tit1           	dc.b    "Tic Tac Toe v1.0",129,0	;Text for title screen
tit2           	dc.b    "By Don Barnes <x96barnes3@wmich.edu>",0
tit3		dc.b	"Copyright 1996",0
tit5		dc.b	"Press any key to begin",0
txturn		dc.b	"Player",0
tstr		dc.l	0
xpos		dc.w	0	;the x pos for drawing x's and o's
ypos		dc.w	0	;the y pos for drawing x's and o's
xcur		dc.w	0	;the x pos for cursor
ycur		dc.w	0	;the y pos for cursor
turn		dc.w	1	;player turn number(who's up, player 1 X or 2 O)
x		dc.w	0	;a value for plotting
y		dc.w	0	;a value for plotting
x2		dc.w	0	;a counter for plotting
cx		dc.w	0	;a value for checking
cy		dc.w	0	;a value for checking
keyz		dc	0	;get key value
val		dc.w	0	;get key value

board:		dc.w	0,0,0,0,0,0,0,0,0,0

;************** End of Fargo program ****************

        reloc_open
        add_library     flib
        add_library     romlib
        reloc_close
        end
