;=========================================
; FChem version 1.0 BETA
; by: David L. Cantrell Jr.
; requires Fargo version 1.0B12
;=========================================

 @program prog_code,prog_name

 include macros.h

prog_code:
 jsr flib[clr_scr]
 SetFont #2
 WriteStr #1,#1,#0,prog_title
 WriteStr #1,#25,#4,title1
 WriteStr #1,#37,#4,title2
 WriteStr #1,#49,#4,title3
 WriteStr #1,#61,#4,title4
 WriteStr #1,#73,#4,title5
 WriteStr #1,#110,#4,prompt
 SetFont #1
 WriteStr #1,#11,#0,author
 SetFont #0
 WriteStr #1,#88,#4,hlp1
 WriteStr #1,#94,#4,hlp2
 move.w #$0000,elem1
 move.w #$0000,elem2
 SetFont #2

GetLetter:
 jsr flib[idle_loop]
 cmp #$108,d0
 bne GetNxt
 bra ExitFChem

GetNxt:
 move.b d0,elem1
 WriteStr #115,#110,#4,elem1
 jsr flib[idle_loop]
 cmp #$108,d0
 beq ExitFChem
 cmp #$D,d0
 beq PutNull
 move.b d0,elem2
 WriteStr #124,#110,#4,elem2
 bra DetElmt

PutNull:
 move.w #$0000,elem2

DetElmt:
 move.w elem1,d6
 move.w elem2,d7

 cmp #$6100,d6
 beq a_test
 cmp #$6200,d6
 beq b_test
 cmp #$6300,d6
 beq c_test
 cmp #$6600,d6
 beq f_test
 cmp #$6700,d6
 beq g_test
 cmp #$6800,d6
 beq h_test
 cmp #$6900,d6
 beq i_test
 cmp #$6B00,d6
 beq k_test
 cmp #$6C00,d6
 beq l_test
 cmp #$6D00,d6
 beq m_test
 cmp #$6E00,d6
 beq n_test
 cmp #$6F00,d6
 beq o_test
 cmp #$7000,d6
 beq p_test
 cmp #$7200,d6
 beq r_test
 cmp #$7300,d6
 beq s_test
 cmp #$7400,d6
 beq t_test
 cmp #$7600,d6
 beq v_test
 cmp #$7700,d6
 beq w_test
 cmp #$7800,d6
 beq x_test
 cmp #$7A00,d6
 beq z_test
 bra not_fnd

v_test:
 cmp #$0000,d7
 beq Vanadium
 bra not_fnd

w_test:
 cmp #$0000,d7
 beq Tungsten
 bra not_fnd

x_test
 cmp #$6500,d7
 beq Xenon
 bra not_fnd

a_test:
 cmp #$6700,d7
 beq Silver
 cmp #$6C00,d7
 beq Aluminum
 cmp #$7200,d7
 beq Argon
 cmp #$7300,d7
 beq Arsenic
 cmp #$7400,d7
 beq Astatine
 cmp #$7500,d7
 beq Gold
 bra not_fnd

b_test:
 cmp #$0000,d7
 beq Boron
 cmp #$6100,d7
 beq Barium
 cmp #$6500,d7
 beq Beryllium
 cmp #$6900,d7
 beq Bismuth
 cmp #$7200,d7
 beq Bromine
 bra not_fnd

c_test:
 cmp #$0000,d7
 beq Carbon
 cmp #$6100,d7
 beq Calcium
 cmp #$6400,d7
 beq Cadmium
 cmp #$6C00,d7
 beq Chlorine
 cmp #$6F00,d7
 beq Cobalt
 cmp #$7200,d7
 beq Chromium
 cmp #$7300,d7
 beq Cesium
 cmp #$7500,d7
 beq Copper
 bra not_fnd

f_test:
 cmp #$0000,d7
 beq Fluorine
 cmp #$6500,d7
 beq Iron
 cmp #$7200,d7
 beq Francium
 bra not_fnd

g_test:
 cmp #$6100,d7
 beq Gallium
 bra not_fnd

h_test:
 cmp #$0000,d7
 beq Hydrogen
 cmp #$6500,d7
 beq Helium
 cmp #$6700,d7
 beq Mercury
 cmp #$7300,d7
 beq Hessium
 bra not_fnd

i_test:
 cmp #$0000,d7
 beq Iodine
 cmp #$6E00,d7
 beq Indium
 cmp #$7200,d7
 beq Iridium
 bra not_fnd

k_test:
 cmp #$0000,d7
 beq Potassium
 cmp #$7200,d7
 beq Krypton
 bra not_fnd

l_test:
 cmp #$6900,d7
 beq Lithium
 bra not_fnd

m_test:
 cmp #$6700,d7
 beq Magnesium
 cmp #$6E00,d7
 beq Manganese
 bra not_fnd

n_test:
 cmp #$0000,d7
 beq Nitrogen
 cmp #$6100,d7
 beq Sodium
 cmp #$6500,d7
 beq Neon
 cmp #$6900,d7
 beq Nickel
 bra not_fnd

o_test:
 cmp #$0000,d7
 beq Oxygen
 bra not_fnd

p_test:
 cmp #$0000,d7
 beq Phosphorus
 cmp #$6200,d7
 beq Lead
 cmp #$6400,d7
 beq Palladium
 cmp #$7400,d7
 beq Platinum
 bra not_fnd

r_test:
 cmp #$6100,d7
 beq Radium
 cmp #$6500,d7
 beq Rhenium
 cmp #$6800,d7
 beq Rhodium
 cmp #$6E00,d7
 beq Radon
 bra not_fnd

s_test:
 cmp #$0000,d7
 beq Sulfur
 cmp #$6200,d7
 beq Antimony
 cmp #$6500,d7
 beq Selenium
 cmp #$6900,d7
 beq Silicon
 cmp #$6E00,d7
 beq Tin
 cmp #$7200,d7
 beq Strontium
 bra not_fnd

t_test:
 cmp #$6100,d7
 beq Tantalum
 cmp #$6500,d7
 beq Tellurium
 cmp #$6900,d7
 beq Titanium
 cmp #$6C00,d7
 beq Thallium
 bra not_fnd

z_test:
 cmp #$6E00,d7
 beq Zinc
 cmp #$7200,d7
 beq Zirconium
 bra not_fnd

Hydrogen:
 bsr BlankIt
 WriteStr #30,#25,#4,hnm
 WriteStr #30,#37,#4,han
 WriteStr #30,#49,#4,hsy
 WriteStr #30,#61,#4,hwt
 WriteStr #30,#73,#4,hox
 bra GetLetter

Helium:
 bsr BlankIt
 WriteStr #30,#25,#4,henm
 WriteStr #30,#37,#4,hean
 WriteStr #30,#49,#4,hesy
 WriteStr #30,#61,#4,hewt
 WriteStr #30,#73,#4,heox
 bra GetLetter

Lithium:
 bsr BlankIt
 WriteStr #30,#25,#4,linm
 WriteStr #30,#37,#4,lian
 WriteStr #30,#49,#4,lisy
 WriteStr #30,#61,#4,liwt
 WriteStr #30,#73,#4,liox
 bra GetLetter

Beryllium:
 bsr BlankIt
 WriteStr #30,#25,#4,benm
 WriteStr #30,#37,#4,bean
 WriteStr #30,#49,#4,besy
 WriteStr #30,#61,#4,bewt
 WriteStr #30,#73,#4,beox
 bra GetLetter

Boron:
 bsr BlankIt
 WriteStr #30,#25,#4,bnm
 WriteStr #30,#37,#4,ban
 WriteStr #30,#49,#4,bsy
 WriteStr #30,#61,#4,bwt
 WriteStr #30,#73,#4,box
 bra GetLetter

Carbon:
 bsr BlankIt
 WriteStr #30,#25,#4,cnm
 WriteStr #30,#37,#4,can
 WriteStr #30,#49,#4,csy
 WriteStr #30,#61,#4,cwt
 WriteStr #30,#73,#4,cox
 bra GetLetter

Nitrogen:
 bsr BlankIt
 WriteStr #30,#25,#4,nnm
 WriteStr #30,#37,#4,nan
 WriteStr #30,#49,#4,nsy
 WriteStr #30,#61,#4,nwt
 WriteStr #30,#73,#4,nox
 bra GetLetter

Oxygen:
 bsr BlankIt
 WriteStr #30,#25,#4,onm
 WriteStr #30,#37,#4,oan
 WriteStr #30,#49,#4,osy
 WriteStr #30,#61,#4,owt
 WriteStr #30,#73,#4,oox
 bra GetLetter

Fluorine:
 bsr BlankIt
 WriteStr #30,#25,#4,fnm
 WriteStr #30,#37,#4,fan
 WriteStr #30,#49,#4,fsy
 WriteStr #30,#61,#4,fwt
 WriteStr #30,#73,#4,fox
 bra GetLetter

Neon:
 bsr BlankIt
 WriteStr #30,#25,#4,nenm
 WriteStr #30,#37,#4,nean
 WriteStr #30,#49,#4,nesy
 WriteStr #30,#61,#4,newt
 WriteStr #30,#73,#4,neox
 bra GetLetter

Sodium:
 bsr BlankIt
 WriteStr #30,#25,#4,nanm
 WriteStr #30,#37,#4,naan
 WriteStr #30,#49,#4,nasy
 WriteStr #30,#61,#4,nawt
 WriteStr #30,#73,#4,naox
 bra GetLetter

Magnesium:
 bsr BlankIt
 WriteStr #30,#25,#4,mgnm
 WriteStr #30,#37,#4,mgan
 WriteStr #30,#49,#4,mgsy
 WriteStr #30,#61,#4,mgwt
 WriteStr #30,#73,#4,mgox
 bra GetLetter

Aluminum:
 bsr BlankIt
 WriteStr #30,#25,#4,alnm
 WriteStr #30,#37,#4,alan
 WriteStr #30,#49,#4,alsy
 WriteStr #30,#61,#4,alwt
 WriteStr #30,#73,#4,alox
 bra GetLetter

Silicon:
 bsr BlankIt
 WriteStr #30,#25,#4,sinm
 WriteStr #30,#37,#4,sian
 WriteStr #30,#49,#4,sisy
 WriteStr #30,#61,#4,siwt
 WriteStr #30,#73,#4,siox
 bra GetLetter

Phosphorus:
 bsr BlankIt
 WriteStr #30,#25,#4,pnm
 WriteStr #30,#37,#4,pan
 WriteStr #30,#49,#4,psy
 WriteStr #30,#61,#4,pwt
 WriteStr #30,#73,#4,pox
 bra GetLetter

Sulfur:
 bsr BlankIt
 WriteStr #30,#25,#4,snm
 WriteStr #30,#37,#4,san
 WriteStr #30,#49,#4,ssy
 WriteStr #30,#61,#4,swt
 WriteStr #30,#73,#4,sox
 bra GetLetter

Chlorine:
 bsr BlankIt
 WriteStr #30,#25,#4,clnm
 WriteStr #30,#37,#4,clan
 WriteStr #30,#49,#4,clsy
 WriteStr #30,#61,#4,clwt
 WriteStr #30,#73,#4,clox
 bra GetLetter

Argon:
 bsr BlankIt
 WriteStr #30,#25,#4,arnm
 WriteStr #30,#37,#4,aran
 WriteStr #30,#49,#4,arsy
 WriteStr #30,#61,#4,arwt
 WriteStr #30,#73,#4,arox
 bra GetLetter

Potassium:
 bsr BlankIt
 WriteStr #30,#25,#4,knm
 WriteStr #30,#37,#4,kan
 WriteStr #30,#49,#4,ksy
 WriteStr #30,#61,#4,kwt
 WriteStr #30,#73,#4,kox
 bra GetLetter

Calcium:
 bsr BlankIt
 WriteStr #30,#25,#4,canm
 WriteStr #30,#37,#4,caan
 WriteStr #30,#49,#4,casy
 WriteStr #30,#61,#4,cawt
 WriteStr #30,#73,#4,caox
 bra GetLetter

Titanium:
 bsr BlankIt
 WriteStr #30,#25,#4,tinm
 WriteStr #30,#37,#4,tian
 WriteStr #30,#49,#4,tisy
 WriteStr #30,#61,#4,tiwt
 WriteStr #30,#73,#4,tiox
 bra GetLetter

Vanadium:
 bsr BlankIt
 WriteStr #30,#25,#4,vnm
 WriteStr #30,#37,#4,van
 WriteStr #30,#49,#4,vsy
 WriteStr #30,#61,#4,vwt
 WriteStr #30,#73,#4,vox
 bra GetLetter

Chromium:
 bsr BlankIt
 WriteStr #30,#25,#4,crnm
 WriteStr #30,#37,#4,cran
 WriteStr #30,#49,#4,crsy
 WriteStr #30,#61,#4,crwt
 WriteStr #30,#73,#4,crox
 bra GetLetter

Manganese:
 bsr BlankIt
 WriteStr #30,#25,#4,mnnm
 WriteStr #30,#37,#4,mnan
 WriteStr #30,#49,#4,mnsy
 WriteStr #30,#61,#4,mnwt
 WriteStr #30,#73,#4,mnox
 bra GetLetter

Iron:
 bsr BlankIt
 WriteStr #30,#25,#4,fenm
 WriteStr #30,#37,#4,fean
 WriteStr #30,#49,#4,fesy
 WriteStr #30,#61,#4,fewt
 WriteStr #30,#73,#4,feox
 bra GetLetter

Cobalt:
 bsr BlankIt
 WriteStr #30,#25,#4,conm
 WriteStr #30,#37,#4,coan
 WriteStr #30,#49,#4,cosy
 WriteStr #30,#61,#4,cowt
 WriteStr #30,#73,#4,coox
 bra GetLetter

Nickel:
 bsr BlankIt
 WriteStr #30,#25,#4,ninm
 WriteStr #30,#37,#4,nian
 WriteStr #30,#49,#4,nisy
 WriteStr #30,#61,#4,niwt
 WriteStr #30,#73,#4,niox
 bra GetLetter

Copper:
 bsr BlankIt
 WriteStr #30,#25,#4,cunm
 WriteStr #30,#37,#4,cuan
 WriteStr #30,#49,#4,cusy
 WriteStr #30,#61,#4,cuwt
 WriteStr #30,#73,#4,cuox
 bra GetLetter

Zinc:
 bsr BlankIt
 WriteStr #30,#25,#4,znnm
 WriteStr #30,#37,#4,znan
 WriteStr #30,#49,#4,znsy
 WriteStr #30,#61,#4,znwt
 WriteStr #30,#73,#4,znox
 bra GetLetter

Gallium:
 bsr BlankIt
 WriteStr #30,#25,#4,ganm
 WriteStr #30,#37,#4,gaan
 WriteStr #30,#49,#4,gasy
 WriteStr #30,#61,#4,gawt
 WriteStr #30,#73,#4,gaox
 bra GetLetter

Arsenic:
 bsr BlankIt
 WriteStr #30,#25,#4,asnm
 WriteStr #30,#37,#4,asan
 WriteStr #30,#49,#4,assy
 WriteStr #30,#61,#4,aswt
 WriteStr #30,#73,#4,asox
 bra GetLetter

Selenium:
 bsr BlankIt
 WriteStr #30,#25,#4,senm
 WriteStr #30,#37,#4,sean
 WriteStr #30,#49,#4,sesy
 WriteStr #30,#61,#4,sewt
 WriteStr #30,#73,#4,seox
 bra GetLetter

Bromine:
 bsr BlankIt
 WriteStr #30,#25,#4,brnm
 WriteStr #30,#37,#4,bran
 WriteStr #30,#49,#4,brsy
 WriteStr #30,#61,#4,brwt
 WriteStr #30,#73,#4,brox
 bra GetLetter

Krypton:
 bsr BlankIt
 WriteStr #30,#25,#4,krnm
 WriteStr #30,#37,#4,kran
 WriteStr #30,#49,#4,krsy
 WriteStr #30,#61,#4,krwt
 WriteStr #30,#73,#4,krox
 bra GetLetter

Strontium:
 bsr BlankIt
 WriteStr #30,#25,#4,srnm
 WriteStr #30,#37,#4,sran
 WriteStr #30,#49,#4,srsy
 WriteStr #30,#61,#4,srwt
 WriteStr #30,#73,#4,srox
 bra GetLetter

Zirconium:
 bsr BlankIt
 WriteStr #30,#25,#4,zrnm
 WriteStr #30,#37,#4,zran
 WriteStr #30,#49,#4,zrsy
 WriteStr #30,#61,#4,zrwt
 WriteStr #30,#73,#4,zrox
 bra GetLetter

Rhodium:
 bsr BlankIt
 WriteStr #30,#25,#4,rhnm
 WriteStr #30,#37,#4,rhan
 WriteStr #30,#49,#4,rhsy
 WriteStr #30,#61,#4,rhwt
 WriteStr #30,#73,#4,rhox
 bra GetLetter

Palladium:
 bsr BlankIt
 WriteStr #30,#25,#4,pdnm
 WriteStr #30,#37,#4,pdan
 WriteStr #30,#49,#4,pdsy
 WriteStr #30,#61,#4,pdwt
 WriteStr #30,#73,#4,pdox
 bra GetLetter

Silver:
 bsr BlankIt
 WriteStr #30,#25,#4,agnm
 WriteStr #30,#37,#4,agan
 WriteStr #30,#49,#4,agsy
 WriteStr #30,#61,#4,agwt
 WriteStr #30,#73,#4,agox
 bra GetLetter

Cadmium:
 bsr BlankIt
 WriteStr #30,#25,#4,cdnm
 WriteStr #30,#37,#4,cdan
 WriteStr #30,#49,#4,cdsy
 WriteStr #30,#61,#4,cdwt
 WriteStr #30,#73,#4,cdox
 bra GetLetter

Indium:
 bsr BlankIt
 WriteStr #30,#25,#4,innm
 WriteStr #30,#37,#4,inan
 WriteStr #30,#49,#4,insy
 WriteStr #30,#61,#4,inwt
 WriteStr #30,#73,#4,inox
 bra GetLetter

Tin:
 bsr BlankIt
 WriteStr #30,#25,#4,snnm
 WriteStr #30,#37,#4,snan
 WriteStr #30,#49,#4,snsy
 WriteStr #30,#61,#4,snwt
 WriteStr #30,#73,#4,snox
 bra GetLetter

Antimony:
 bsr BlankIt
 WriteStr #30,#25,#4,sbnm
 WriteStr #30,#37,#4,sban
 WriteStr #30,#49,#4,sbsy
 WriteStr #30,#61,#4,sbwt
 WriteStr #30,#73,#4,sbox
 bra GetLetter

Tellurium:
 bsr BlankIt
 WriteStr #30,#25,#4,tenm
 WriteStr #30,#37,#4,tean
 WriteStr #30,#49,#4,tesy
 WriteStr #30,#61,#4,tewt
 WriteStr #30,#73,#4,teox
 bra GetLetter

Iodine:
 bsr BlankIt
 WriteStr #30,#25,#4,inm
 WriteStr #30,#37,#4,ian
 WriteStr #30,#49,#4,isy
 WriteStr #30,#61,#4,iwt
 WriteStr #30,#73,#4,iox
 bra GetLetter

Xenon:
 bsr BlankIt
 WriteStr #30,#25,#4,xenm
 WriteStr #30,#37,#4,xean
 WriteStr #30,#49,#4,xesy
 WriteStr #30,#61,#4,xewt
 WriteStr #30,#73,#4,xeox
 bra GetLetter

Cesium:
 bsr BlankIt
 WriteStr #30,#25,#4,csnm
 WriteStr #30,#37,#4,csan
 WriteStr #30,#49,#4,cssy
 WriteStr #30,#61,#4,cswt
 WriteStr #30,#73,#4,csox
 bra GetLetter

Barium:
 bsr BlankIt
 WriteStr #30,#25,#4,banm
 WriteStr #30,#37,#4,baan
 WriteStr #30,#49,#4,basy
 WriteStr #30,#61,#4,bawt
 WriteStr #30,#73,#4,baox
 bra GetLetter

Tantalum:
 bsr BlankIt
 WriteStr #30,#25,#4,tanm
 WriteStr #30,#37,#4,taan
 WriteStr #30,#49,#4,tasy
 WriteStr #30,#61,#4,tawt
 WriteStr #30,#73,#4,taox
 bra GetLetter

Tungsten:
 bsr BlankIt
 WriteStr #30,#25,#4,wnm
 WriteStr #30,#37,#4,wan
 WriteStr #30,#49,#4,wsy
 WriteStr #30,#61,#4,wwt
 WriteStr #30,#73,#4,wox
 bra GetLetter

Rhenium:
 bsr BlankIt
 WriteStr #30,#25,#4,renm
 WriteStr #30,#37,#4,rean
 WriteStr #30,#49,#4,resy
 WriteStr #30,#61,#4,rewt
 WriteStr #30,#73,#4,reox
 bra GetLetter

Iridium:
 bsr BlankIt
 WriteStr #30,#25,#4,irnm
 WriteStr #30,#37,#4,iran
 WriteStr #30,#49,#4,irsy
 WriteStr #30,#61,#4,irwt
 WriteStr #30,#73,#4,irox
 bra GetLetter

Platinum:
 bsr BlankIt
 WriteStr #30,#25,#4,ptnm
 WriteStr #30,#37,#4,ptan
 WriteStr #30,#49,#4,ptsy
 WriteStr #30,#61,#4,ptwt
 WriteStr #30,#73,#4,ptox
 bra GetLetter

Gold:
 bsr BlankIt
 WriteStr #30,#25,#4,aunm
 WriteStr #30,#37,#4,auan
 WriteStr #30,#49,#4,ausy
 WriteStr #30,#61,#4,auwt
 WriteStr #30,#73,#4,auox
 bra GetLetter

Mercury:
 bsr BlankIt
 WriteStr #30,#25,#4,hgnm
 WriteStr #30,#37,#4,hgan
 WriteStr #30,#49,#4,hgsy
 WriteStr #30,#61,#4,hgwt
 WriteStr #30,#73,#4,hgox
 bra GetLetter

Thallium:
 bsr BlankIt
 WriteStr #30,#25,#4,tlnm
 WriteStr #30,#37,#4,tlan
 WriteStr #30,#49,#4,tlsy
 WriteStr #30,#61,#4,tlwt
 WriteStr #30,#73,#4,tlox
 bra GetLetter

Lead:
 bsr BlankIt
 WriteStr #30,#25,#4,pbnm
 WriteStr #30,#37,#4,pban
 WriteStr #30,#49,#4,pbsy
 WriteStr #30,#61,#4,pbwt
 WriteStr #30,#73,#4,pbox
 bra GetLetter

Bismuth:
 bsr BlankIt
 WriteStr #30,#25,#4,binm
 WriteStr #30,#37,#4,bian
 WriteStr #30,#49,#4,bisy
 WriteStr #30,#61,#4,biwt
 WriteStr #30,#73,#4,biox
 bra GetLetter

Astatine:
 bsr BlankIt
 WriteStr #30,#25,#4,atnm
 WriteStr #30,#37,#4,atan
 WriteStr #30,#49,#4,atsy
 WriteStr #30,#61,#4,atwt
 WriteStr #30,#73,#4,atox
 bra GetLetter

Radon:
 bsr BlankIt
 WriteStr #30,#25,#4,rnnm
 WriteStr #30,#37,#4,rnan
 WriteStr #30,#49,#4,rnsy
 WriteStr #30,#61,#4,rnwt
 WriteStr #30,#73,#4,rnox
 bra GetLetter

Francium:
 bsr BlankIt
 WriteStr #30,#25,#4,frnm
 WriteStr #30,#37,#4,fran
 WriteStr #30,#49,#4,frsy
 WriteStr #30,#61,#4,frwt
 WriteStr #30,#73,#4,frox
 bra GetLetter

Radium:
 bsr BlankIt
 WriteStr #30,#25,#4,ranm
 WriteStr #30,#37,#4,raan
 WriteStr #30,#49,#4,rasy
 WriteStr #30,#61,#4,rawt
 WriteStr #30,#73,#4,raox
 bra GetLetter

Hessium:
 bsr BlankIt
 WriteStr #30,#25,#4,hsnm
 WriteStr #30,#37,#4,hsan
 WriteStr #30,#49,#4,hssy
 WriteStr #30,#61,#4,hswt
 WriteStr #30,#73,#4,hsox
 bra GetLetter

not_fnd:
 bsr BlankIt
 WriteStr #30,#49,#4,notfnd
 bra GetLetter

BlankIt:
 WriteStr #30,#25,#4,blx
 WriteStr #30,#37,#4,blx
 WriteStr #30,#49,#4,blx
 WriteStr #30,#61,#4,blx
 WriteStr #30,#73,#4,blx
 WriteStr #115,#110,#4,blx2
 rts

ExitFChem:
 rts

;---------------
; vars
;---------------
elem1         dc.w 0      ;the first character the user enters (word)
elem2         dc.w 0      ;the second character the user enters (word)

;---------------------
; strings
;---------------------
author        dc.b "Copyright (c) 1996 David L. Cantrell Jr.",0
title1        dc.b "NM:",0
title2        dc.b "AN:",0
title3        dc.b "SY:",0
title4        dc.b "WT:",0
title5        dc.b "OX:",0
hlp1          dc.b "NM=Name, AN=Atomic Number, SY=Symbol, WT=Atomic Weight,",0
hlp2          dc.b "OX=Oxidation States.  Type symbol to get info.  ESC to exit FChem.",0
prompt        dc.b "Search for? ->",0
notfnd        dc.b "--- Not Found ---",0
prog_title    dc.b "FChem version 1.0 BETA        ",0
prog_name     dc.b "FChem - A Periodic Table",0
blx           dc.b "                 ",0
blx2          dc.b "      ",0
han    dc.b "1",0
hnm    dc.b "Hydrogen",0
hsy    dc.b "H",0
hwt    dc.b "1.007 94",0
hox    dc.b "1,-1",0
hean   dc.b "2",0
henm   dc.b "Helium",0
hesy   dc.b "He",0
hewt   dc.b "4.002 602",0
heox   dc.b "0",0
lian   dc.b "3",0
linm   dc.b "Lithium",0
lisy   dc.b "Li",0
liwt   dc.b "6.941",0
liox   dc.b "1",0
bean   dc.b "4",0
benm   dc.b "Beryllium",0
besy   dc.b "Be",0
bewt   dc.b "9.012 182",0
beox   dc.b "2",0
ban    dc.b "5",0
bnm    dc.b "Boron",0
bsy    dc.b "B",0
bwt    dc.b "10.811",0
box    dc.b "3",0
can    dc.b "6",0
cnm    dc.b "Carbon",0
csy    dc.b "C",0
cwt    dc.b "12.011",0
cox    dc.b "(4),(-4),2",0
nan    dc.b "7",0
nnm    dc.b "Nitrogen",0
nsy    dc.b "N",0
nwt    dc.b "14.006 74",0
nox    dc.b "(3),(-3),5,4,-2,2,-1,1",0
oan    dc.b "8",0
onm    dc.b "Oxygen",0
osy    dc.b "O",0
owt    dc.b "15.999 4",0
oox    dc.b "-2",0
fan    dc.b "9",0
fnm    dc.b "Fluorine",0
fsy    dc.b "F",0
fwt    dc.b "18.998 403 2",0
fox    dc.b "-1",0
nean   dc.b "10",0
nenm   dc.b "Neon",0
nesy   dc.b "Ne",0
newt   dc.b "20.179 7",0
neox   dc.b "0",0
naan   dc.b "11",0
nanm   dc.b "Sodium",0
nasy   dc.b "Na",0
nawt   dc.b "22.989 768",0
naox   dc.b "1",0
mgan   dc.b "12",0
mgnm   dc.b "Magnesium",0
mgsy   dc.b "Mg",0
mgwt   dc.b "24.305 0",0
mgox   dc.b "2",0
alan   dc.b "13",0
alnm   dc.b "Aluminum",0
alsy   dc.b "Al",0
alwt   dc.b "26.981 539",0
alox   dc.b "3",0
sian   dc.b "14",0
sinm   dc.b "Silicon",0
sisy   dc.b "Si",0
siwt   dc.b "28.085 5",0
siox   dc.b "2,(4),-4",0
pan    dc.b "15",0
pnm    dc.b "Phosphorus",0
psy    dc.b "P",0
pwt    dc.b "30.973 762",0
pox    dc.b "3,-3,(5),7",0
san    dc.b "16",0
snm    dc.b "Sulfur",0
ssy    dc.b "S",0
swt    dc.b "32.066",0
sox    dc.b "2,-2,4,(6)",0
clan   dc.b "17",0
clnm   dc.b "Chlorine",0
clsy   dc.b "Cl",0
clwt   dc.b "35.452 7",0
clox   dc.b "(1),(-1),3,5,7",0
aran   dc.b "18",0
arnm   dc.b "Argon",0
arsy   dc.b "Ar",0
arwt   dc.b "39.948",0
arox   dc.b "0",0
kan    dc.b "19",0
knm    dc.b "Potassium",0
ksy    dc.b "K",0
kwt    dc.b "39.098 3",0
kox    dc.b "1",0
caan   dc.b "20",0
canm   dc.b "Calcium",0
casy   dc.b "Ca",0
cawt   dc.b "40.078",0
caox   dc.b "2",0
tian   dc.b "22",0
tinm   dc.b "Titanium",0
tisy   dc.b "Ti",0
tiwt   dc.b "47.88",0
tiox   dc.b "(4),3,2",0
van    dc.b "23",0
vnm    dc.b "Vanadium",0
vsy    dc.b "V",0
vwt    dc.b "50.941 5",0
vox    dc.b "(5),4,3,2",0
cran   dc.b "24",0
crnm   dc.b "Chromium",0
crsy   dc.b "Cr",0
crwt   dc.b "51.996 1",0
crox   dc.b "6,(3),2",0
mnan   dc.b "25",0
mnnm   dc.b "Manganese",0
mnsy   dc.b "Mn",0
mnwt   dc.b "54.938 05",0
mnox   dc.b "7,6,4,(2),3",0
fean   dc.b "26",0
fenm   dc.b "Iron",0
fesy   dc.b "Fe",0
fewt   dc.b "55.847",0
feox   dc.b "2,(3)",0
coan   dc.b "27",0
conm   dc.b "Cobalt",0
cosy   dc.b "Co",0
cowt   dc.b "58.933 20",0
coox   dc.b "(2),3",0
nian   dc.b "28",0
ninm   dc.b "Nickel",0
nisy   dc.b "Ni",0
niwt   dc.b "58.69",0
niox   dc.b "(2),3",0
cuan   dc.b "29",0
cunm   dc.b "Copper",0
cusy   dc.b "Cu",0
cuwt   dc.b "63.546",0
cuox   dc.b "(2),1",0
znan   dc.b "30",0
znnm   dc.b "Zinc",0
znsy   dc.b "Zn",0
znwt   dc.b "65.39",0
znox   dc.b "2",0
gaan   dc.b "31",0
ganm   dc.b "Gallium",0
gasy   dc.b "Ga",0
gawt   dc.b "69.723",0
gaox   dc.b "3",0
asan   dc.b "33",0
asnm   dc.b "Arsenic",0
assy   dc.b "As",0
aswt   dc.b "74.921 59",0
asox   dc.b "(3),(-3),5",0
sean   dc.b "34",0
senm   dc.b "Selenium",0
sesy   dc.b "Se",0
sewt   dc.b "78.96",0
seox   dc.b "-2,(4),6",0
bran   dc.b "35",0
brnm   dc.b "Bromine",0
brsy   dc.b "Br",0
brwt   dc.b "79.904",0
brox   dc.b "(1),(-1),5",0
kran   dc.b "36",0
krnm   dc.b "Krypton",0
krsy   dc.b "Kr",0
krwt   dc.b "83.80",0
krox   dc.b "0",0
sran   dc.b "38",0
srnm   dc.b "Strontium",0
srsy   dc.b "Sr",0
srwt   dc.b "87.62",0
srox   dc.b "2",0
zran   dc.b "40",0
zrnm   dc.b "Zirconium",0
zrsy   dc.b "Zr",0
zrwt   dc.b "91.224",0
zrox   dc.b "4",0
rhan   dc.b "45",0
rhnm   dc.b "Rhodium",0
rhsy   dc.b "Rh",0
rhwt   dc.b "102.905 50",0
rhox   dc.b "2,(3),4",0
pdan   dc.b "46",0
pdnm   dc.b "Palladium",0
pdsy   dc.b "Pd",0
pdwt   dc.b "106.42",0
pdox   dc.b "(2),4",0
agan   dc.b "47",0
agnm   dc.b "Silver",0
agsy   dc.b "Ag",0
agwt   dc.b "107.868 2",0
agox   dc.b "1",0
cdan   dc.b "48",0
cdnm   dc.b "Cadmium",0
cdsy   dc.b "Cd",0
cdwt   dc.b "112.411",0
cdox   dc.b "2",0
inan   dc.b "49",0
innm   dc.b "Indium",0
insy   dc.b "In",0
inwt   dc.b "114.82",0
inox   dc.b "3",0
snan   dc.b "50",0
snnm   dc.b "Tin",0
snsy   dc.b "Sn",0
snwt   dc.b "118.710",0
snox   dc.b "(4),2",0
sban   dc.b "51",0
sbnm   dc.b "Antimony",0
sbsy   dc.b "Sb",0
sbwt   dc.b "121.75",0
sbox   dc.b "(3),(-3),5",0
tean   dc.b "52",0
tenm   dc.b "Tellurium",0
tesy   dc.b "Te",0
tewt   dc.b "127.60",0
teox   dc.b "-2,(4),6",0
ian    dc.b "53",0
inm    dc.b "Iodine",0
isy    dc.b "I",0
iwt    dc.b "126.904 47",0
iox    dc.b "(1),(-1),5,7",0
xean   dc.b "54",0
xenm   dc.b "Xenon",0
xesy   dc.b "Xe",0
xewt   dc.b "131.290",0
xeox   dc.b "0",0
csan   dc.b "55",0
csnm   dc.b "Cesium",0
cssy   dc.b "Cs",0
cswt   dc.b "132.905 43",0
csox   dc.b "1",0
baan   dc.b "56",0
banm   dc.b "Barium",0
basy   dc.b "Ba",0
bawt   dc.b "137.327",0
baox   dc.b "2",0
gdan   dc.b "64",0
gdnm   dc.b "Gadolinium",0
gdsy   dc.b "Gd",0
gdwt   dc.b "157.25",0
gdox   dc.b "3",0
taan   dc.b "73",0
tanm   dc.b "Tantalum",0
tasy   dc.b "Ta",0
tawt   dc.b "180.947 9",0
taox   dc.b "5",0
wan    dc.b "74",0
wnm    dc.b "Tungsten",0
wsy    dc.b "W",0
wwt    dc.b "183.85",0
wox    dc.b "(6),5,4,3,2",0
rean   dc.b "75",0
renm   dc.b "Rhenium",0
resy   dc.b "Re",0
rewt   dc.b "186.207",0
reox   dc.b "(7),6,4,2,-1",0
iran   dc.b "77",0
irnm   dc.b "Iridium",0
irsy   dc.b "Ir",0
irwt   dc.b "192.22",0
irox   dc.b "2,3,(4),6",0
ptan   dc.b "78",0
ptnm   dc.b "Platinum",0
ptsy   dc.b "Pt",0
ptwt   dc.b "195.08",0
ptox   dc.b "2,(4)",0
auan   dc.b "79",0
aunm   dc.b "Gold",0
ausy   dc.b "Au",0
auwt   dc.b "196.966 54",0
auox   dc.b "(3),1",0
hgan   dc.b "80",0
hgnm   dc.b "Mercury",0
hgsy   dc.b "Hg",0
hgwt   dc.b "200.59",0
hgox   dc.b "(2),1",0
tlan   dc.b "81",0
tlnm   dc.b "Thallium",0
tlsy   dc.b "Tl",0
tlwt   dc.b "204.383 3",0
tlox   dc.b "3,(1)",0
pban   dc.b "82",0
pbnm   dc.b "Lead",0
pbsy   dc.b "Pb",0
pbwt   dc.b "207.2",0
pbox   dc.b "4,(2)",0
bian   dc.b "83",0
binm   dc.b "Bismuth",0
bisy   dc.b "Bi",0
biwt   dc.b "208.980 37",0
biox   dc.b "(3),5",0
atan   dc.b "85",0
atnm   dc.b "Astatine",0
atsy   dc.b "At",0
atwt   dc.b "209.987 1",0
atox   dc.b "(1),(-1),3,5,7",0
rnan   dc.b "86",0
rnnm   dc.b "Radon",0
rnsy   dc.b "Rn",0
rnwt   dc.b "222.017 6",0
rnox   dc.b "0",0
fran   dc.b "87",0
frnm   dc.b "Francium",0
frsy   dc.b "Fr",0
frwt   dc.b "223.019 7",0
frox   dc.b "1",0
raan   dc.b "88",0
ranm   dc.b "Radium",0
rasy   dc.b "Ra",0
rawt   dc.b "226.025 4",0
raox   dc.b "2",0
hsan   dc.b "108",0
hsnm   dc.b "Hessium",0
hssy   dc.b "Hs",0
hswt   dc.b "265",0
hsox   dc.b "--",0



;=========END FARGO PROGRAM===========
 reloc_open
 add_library romlib
 add_library flib
 reloc_close
 end
