; --------------------------------
;  Pixel Plotting
;  Macros
;
;  (c) 1996 Christopher Poole
;  poole.christopher@paradox.net
;  Please include with your programs
;  vE05 - 11.17.96
; --------------------------------

SuperPlot  MACRO
;Usage - SuperPlot x,y,h,w,mode
;                  x & y are coords
;                  h & w are dimensions
;                  mode is the plotting mode
;                  0=off 1=on other=change

                                                move.w  \1,d4
                                                move.w  \2,d5
                                                move.w  \3,d6
                                                move.w  \4,d3
                                      sup_p_x:
                                                cmp     #1,\5
                                                beq     sup_p_on
                                                cmp     #0,\5
                                                beq     sup_p_off
                                                PlotChg d4,d5
                                                jmp     sup_p_ret
                                      sup_p_on:
                                                PlotOn  d4,d5
                                                jmp     sup_p_ret
                                      sup_p_off:
                                                PlotOff d4,d5
                                      sup_p_ret:
                                                add.w   #1,d4
                                                sub.w   #1,d3
                                                cmp     #0,d3
                                                beq     sup_p_y
                                                jmp     sup_p_x
                                      sup_p_y:
                                                move.w  \1,d4
                                                move.w  \4,d3
                                                add.w   #1,d5
                                                sub.w   #1,d6
                                                cmp     #0,d6
                                                bne     sup_p_x
                                      sup_finish:
                                      ENDM

PlotOn     MACRO

                                                Push.w  \2
                                                Push.w  \1
                                                jsr     flib[pixel_on]                                                flib[pixel_on]
                                                lea     4(a7),a7
					 ENDM

PlotOff    MACRO

                                                Push.w  \2
                                                Push.w  \1
                                                jsr     flib[pixel_off]
                                                lea     4(a7),a7
					 ENDM

PlotChg    MACRO

                                                Push.w  \2
                                                Push.w  \1
                                                jsr     flib[pixel_chg]
                                                lea     4(a7),a7
					 ENDM

Push       MACRO

                                                move.\0  \1,-(a7)
                                         ENDM

Pull       MACRO

                                                move.\0  -(a7),\1
                                         ENDM
